/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ConstantRadiusBlending.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"

//	Blends with the constant radius and return the newly created blend.
//  if Chamfer is set then it is constant Chamfering.Other paramrters are
//	self explanatory.

HRESULT ConstantRadiusBlending(ISet *pEdge, VARIANT_BOOL bChamfer, VARIANT_BOOL bFlipped, VARIANT_BOOL bPropagate, VARIANT_BOOL bSmoothVariation, VARIANT_BOOL bGroupEdges, double radius, CString blendName, IBlend **pBlend) 
{

	START_METHOD("ConstantRadiusBlending")

	HRESULT  status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IBlend *blend = NULL;
	status = (GetCLASS(Blend))->CreateBlend(pDesign, CAST(IObjectOrSet, pEdge), bChamfer, 0, radius ,0, &blend);
	CHECK_RETURN_STATUS(status)

	IOperation *operation=CAST(IOperation, blend);

	status = operation->SetName(blendName.AllocSysString()) ;
	CHECK_RETURN_STATUS(status)
	*pBlend = blend ;

	END_METHOD("ConstantRadiusBlending")
}
